@extends('template.master')

@push('styles')
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.css">
<link rel="stylesheet" href="//cdn.datatables.net/1.13.4/css/dataTables.bootstrap4.min.css">
<style>
    .dataTables_filter,
    .dataTables_info {
        display: none;
    }

    .dataTable {
        width: none !important;
    }

    .modal-content>.modal-body>p>img {
        object-fit: contain;
        width: 100% !important;
        height: 100% !important;
    }
</style>
@endpush
@section('content')

<div class=" mt-4">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card card-secondary">
                <div class="card-header" style="background: #000000;color: #f0ac63 !important;">
                    <h3 class="card-title">Article List</h3>
                    <a href="{{ route('articles.form') }}" class="btn float-right" style="background: #f0ac63;color: #000000 !important;">Add</a>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    @if(session()->has('message'))
                    <div class="alert alert-success alert-dismissible">
                        {{ session()->get('message') }}
                    </div>
                    @endif
                    {{-- <form class="form" id="taxo-form" action="{{ route('articles.add') }}" method="POST">
                    <div class="col-md-4 cat_level level6_com">
                        <div class="form-group">
                            <label for="exampleInputName1"><b>Company</b></label>
                            <select class="select2" id="level6_com" multiple="multiple" data-placeholder="Select a State" style="width: 100%;" name="company_id[]">

                            </select>
                        </div>
                    </div>
                    </form> --}}
                    <div class="row my-2">
                        <div class="form-group col-3">
                            <label><strong>Category :</strong></label>

                            <select id='category_id' name="category_id" class="form-control">
                                <option value="">--Select Category--</option>
                                @foreach($categories as $category_id => $category_name)
                                <option value="{{$category_id}}">{{$category_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label><strong>Subscription Level :</strong></label>
                            <select id='subscription_id' name="subscription_id" class="form-control">
                                <option value="">--Select Subscription--</option>
                                @foreach($subscriptions as $subscription_id => $subscription_name)
                                <option value="{{$subscription_id}}">{{$subscription_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label><strong>Interest : </strong></label>
                            <select id='interest_id' name="interest_id" class="form-control">
                                <option value="">--Select Interest --</option>
                                @foreach($interests as $interest_id => $interest_name)
                                <option value="{{$interest_id}}">{{$interest_name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label><strong>Media : </strong></label>
                            <select id='media_selection' name="media_selection" class="form-control">
                                <option value="">--Select Media--</option>
                                <option value="Article">Article</option>
                                <option value="Resource">Resource</option>
                                <option value="Audio">Audio</option>
                                <option value="Video">Video</option>

                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label><strong>Start Date : </strong></label>
                            <input type="date" name="start_date" id="start_date" class="form-control">
                        </div>
                        <div class="form-group col-3">
                            <label><strong>End Date : </strong></label>
                            <input type="date" name="end_date" id="end_date" class="form-control">

                        </div>
                        <div class="form-group col-3">
                            <label><strong>Article Title :</strong></label>
                            <input type="text" placeholder="Search Your Article Name" name="name_search" id="name_search" class="form-control">
                        </div>
                        <div class="form-group col-3">
                            <label><strong>Publisher : </strong></label>
                            <select id='publisher' name="publisher" class="form-control">
                                <option value="">--Select Publisher--</option>
                                @foreach($publishers as $key => $publisher_name)
                                <option value="{{$publisher_name}}"> {{$publisher_name}} </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <table class="table table-bordered" id="example" style="width:none !important">
                        <thead>
                            <tr>
                                <th style="width: 10px">No.</th>
                                <th>Article Title</th>
                                <th>Media Type</th>
                                <th>Category</th>
                                <th>Publisher</th>
                                <th>Subscription Level</th>


                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            {{-- @php $i=0; @endphp
                            @foreach($data_artical as $key => $value)  
                                @php
                                    $sub = json_decode($value->subscription_level, true);
                                    $sub_level=[];
                                    foreach ($sub as $keys => $values) {
                                        $sub_level[]='level '.$values;
                                    }
                                    $categorys = json_decode($value->category_id, true);
                                    

                                    $cat=Illuminate\Support\Facades\DB::table('category')->whereIn('category_id',$categorys)-> pluck ('category_name');
                                    $category=json_decode($cat, true);
                                @endphp                              
                                <tr>
                                    <td>{{$i}}</td>
                            <td>{{$value->article_name}}</td>
                            <td>{{$value->media_selection}}</td>
                            <td>{{implode(', ',$category)}}</td>
                            <td>{{$value->publisher}}</td>
                            <td>{{implode(', ',$sub_level)}}</td>
                            <td><a href="{{ route('articles.edit', $value->article_id) }}" class="btn" style="background: #000000;color: #f0ac63 !important;">Edit</a>
                                <a href="{{ route('articles.delete', $value->article_id) }}" class="btn" onclick="return confirm('Are you sure Delete This Article?')" style="background: #f0ac63;color: #000000 !important;">Delete</a>
                            </td>

                            </tr>
                            @endforeach --}}
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->

                <div class="card-footer">

                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Preview</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

@endsection
@push('child-scripts')
<script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="//cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script>
    $('#exampleModal').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var recipient = button.data('whatever')
        var modal = $(this)
        $.ajax({
            url: '{{ route('ajax.request') }}',
            type: 'POST',
            data: {
                "_token": "{{ csrf_token() }}",
                id: recipient,
                // Optional data to send with the request
            },
            success: function(response) {
                // Update your HTML with the received response
                modal.find('.modal-body').html(response.html)
                //$('#targetElement').html(response.html);
            },
            error: function(xhr, status, error) {
                // Handle any errors
            }
        });
    })
</script>
<script>
    $(document).ready(function() {
        // ON SELECTING ROW
        console.log('hello');
        $("#modal-default").on("click", function() {
            console.log('hello');

        })
    });
    $(document).ready(function() {
        let table = $('#example').DataTable({
            columnDefs: [{
                "defaultContent": "-",
                "targets": "_all"
            }],
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('articles.ajaxList') }}",
                data: function(d) {
                    d.category_id = $('#category_id').val();
                    d.subscription_id = $('#subscription_id').val();
                    d.category_id = $('#category_id').val();
                    d.interest_id = $('#interest_id').val();
                    d.media_selection = $('#media_selection').val();

                    d.start_date = $('#start_date').val();
                    d.end_date = $('#end_date').val();
                    d.name_search = $('#name_search').val();
                    d.publisher = $('#publisher').val();
                }
            },
            columns: [{
                    data: 'id',
                    name: 'id',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: 'article_name',
                    name: 'article_name'
                },
                {
                    data: 'media_selection',
                    name: 'media_selection'
                },
                {
                    data: 'category',
                    name: 'category'
                },
                {
                    data: 'publisher',
                    name: 'publisher'
                },
                {
                    data: 'subscription_level',
                    name: 'subscription_level'
                },
                {
                    data: 'action',
                    name: 'action'
                }
            ]

        });


        function redrawTable() {
            table.draw();
        }

        $('#category_id, #interest_id, #subscription_id, #media_selection, #start_date, #end_date, #name_search, #publisher').change(redrawTable);


    });
</script>
@endpush