@extends('template.master')

@push('styles')
    <!-- Select2 -->

    <style>
        .img_pre{
            width: 200px;
            height: 200px;
            padding: 10px;
        }
        .note-editable{
            min-height: 300px !important;
        }
        .modal-content>.modal-body >p > img {
            object-fit: contain;
            width: 100% !important;
            height: 100% !important;
        }
    </style>
@endpush

@section('content')
    <div class="mt-4">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card card-secondary">
                    <div class="card-header" style="background: #000000;color: #f0ac63 !important;">
                        <h4 class="card-title text-dark" style="color: #f0ac63 !important;"><strong>Add/Edit Article</strong></h4>
                        <a href="{{ route('articles.list') }}" class="btn float-right" style="background: #f0ac63;color: #000000 !important;">Back</a>
                    </div>
                    <div class="card-body">
                        <form class="form" action="{{ route('articles.update') }}" id="taxo-form" method="POST" enctype="multipart/form-data">
                        {{-- <form class="form" id="taxo-form" action="{{route('articles.add')}}" method="POST"> --}}
                            @csrf
                            <input type="hidden" name="article_id" value="{{ $data_artical['article_id'] }}">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Article Title</label>
                                        <input type="text" class="form-control" id="article_name" name="article_name"
                                            placeholder="Article Name" value="{{ $data_artical['article_name'] }}" required maxlength="255">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Search Text</label>
                                        <input type="text" class="form-control" id="search_text" name="search_text"
                                            placeholder="Search Text" value="{{ $data_artical['search_text'] }}" required maxlength="255">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2"><b>Media Selection</b></label>
                                        {{-- <input type="text" class="form-control" id="name" name="name"
                                            placeholder="Name"> --}}
                                        <select class="select2" id="media" data-placeholder="Select a Media"
                                            style="width: 100%;" name="media_selection">
                                            <option value="NULL">Select Media</option>
                                            <option value="Article" @php if($data_artical['media_selection']=="Article"){ echo "selected"; } @endphp >Article</option>
                                            <option value="Resource"  @php if($data_artical['media_selection']=="Resource"){ echo "selected"; } @endphp>Resource</option>
                                            {{-- <option value="Image" if($data_artical['media_selection']=='Image'){ dd('selected'); }>Image</option> --}}
                                            <option value="Audio" @php if($data_artical['media_selection']=="Audio"){ echo "selected"; }@endphp>Audio</option>
                                            <option value="Video" @php if($data_artical['media_selection']=="Video"){ echo "selected"; } @endphp>Video</option>
                                            {{-- @foreach ($media as $mediaKey => $mediaValue)
                                                <option value="{{ $mediaKey }}">{{ $mediaValue->media_name }}</option>
                                            @endforeach --}}
                                        </select>
                                        
                                    </div>
                                </div>
                                <div class="col-md-6 media_resource">
                                    <div class="form-group">
                                        <label for="exampleInputName1" id="media_resource" class="mt-2"><b>Resource</b></label>
                                        <input type="file" class="form-control" id="resource" name="resource"
                                            placeholder="Resource" accept=".pdf,.doc">
                                    </div>
                                </div>
                                {{-- <div class="col-md-6 media_image">
                                    <div class="form-group">
                                        <label for="exampleInputName1" id="media_image" class="mt-2"><b>Image</b></label>
                                        <input type="file" class="form-control" id="image" name="image[]"
                                            placeholder="Image" multiple >
                                    </div>
                                </div> --}}
                                <div class="col-md-6 media_youtube">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2"><b>Video</b></label>
                                        <input type="text" class="form-control" id="media_youtube" name="youtube_url"
                                            placeholder="https://" value="{{ $data_artical['youtube_url'] }}">
                                    </div>
                                </div>
                            
                            
                                <div class="col-md-6 media_audio">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2"><b>Audio</b></label>
                                        {{-- <input type="file" class="form-control" id="media_audio" name="audio"
                                            placeholder="audio" accept="audio/mp3,audio/*;capture=microphone" /> --}}
                                        <input type="text" class="form-control" id="media_audio" name="audio"
                                            placeholder="https://" value="{{ $data_artical['audio'] }}">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail3" class="mt-2"><b>Article Date</b></label>
                                        <input type="date" class="form-control" id="publish_date" name="publish_date"
                                        value="{{ $data_artical['publish_date'] }}" placeholder="Publish Date" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail3" class="mt-2"><b>Publisher</b></label>
                                        
                                        <select class="select2" data-placeholder="Select a Publisher"
                                            style="width: 100%;" name="publisher" required>
                                        <option value="NULL">Select Publisher</option>
                                            @foreach ($publisher as $publisherKey => $publisherValue)
                                                <option value="{{ $publisherValue->publisher_name }}"  @if($data_artical['publisher']=="$publisherValue->publisher_name"){ selected } @endif>{{ $publisherValue->publisher_name }}</option>
                                            @endforeach
                                        </select>
                                        <!--<input list="select"  class="form-control"  id="publisher" name="publisher"-->
                                        <!--    placeholder="publisher" value="{{ $data_artical['publisher'] }}" required maxlength="255">-->
                                        <!--<datalist id="select">-->
                                        <!--    @foreach ($publisher as $publisherKey => $publisherValue)-->
                                        <!--        <option value="{{ $publisherValue->publisher_name }}"></option>-->
                                        <!--    @endforeach-->
                                        <!--</datalist>-->
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 level6_cat">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Category</b></label>
                                        @php
                                            $categorys=json_decode($data_artical['category_id']);
                                        @endphp
                                        <select class="select2" id="level6_cat" multiple="multiple" data-placeholder="Select a Category"
                                            style="width: 100%;" name="category_id[]" required>
                                            @foreach ($category as $catKey => $catValue)
                                                <option value="{{ $catValue->category_id }}" {{in_array($catValue->category_id,$categorys)?'selected':'';}}>{{ $catValue->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="exampleInputName1"><b>Interest</b></label>
                                    @php
                                        $interests=json_decode($data_artical['interest_id']);
                                    @endphp
                                    <select class="select2" multiple="multiple" data-placeholder="Select a Interest"
                                        style="width: 100%;" name="interest_id[]" required>
                                    @foreach ($interest as $interestKey => $interestValue)
                                        <option value=""></option>
                                        <option value="{{ $interestValue->interest_id }}" {{in_array($interestValue->interest_id,$interests)?'selected':'';}}>{{ $interestValue->interest_name }}</option>
                                    @endforeach
                                    </select>                                   
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Subscription level</b></label>
                                        @php
                                            $sub_level=[];
                                            $level=json_decode($data_artical['subscription_level']);
                                            
                                        @endphp
                                        <select class="select2"  id="sub_level" multiple="multiple" data-placeholder="Select a Subscription" style="width: 100%;" name="subscription_level[]" required>
                                        @foreach ($subscription as $subscriptionKey => $subscriptionValue)
                                            <option value="{{ $subscriptionValue->subscription_id }}" {{in_array($subscriptionValue->subscription_id,$level)?'selected':'';}}>level {{ $subscriptionValue->subscription_level }} - {{ $subscriptionValue->subscription_name }}</option>
                                        @endforeach
                                            {{-- <option value="1" {{in_array('1',$level)?'selected':'';}}>Level 1</option>
                                            <option value="2" {{in_array('2',$level)?'selected':'';}}>Level 2</option>
                                            <option value="4" {{in_array('3',$level)?'selected':'';}}>Level 4</option>
                                            <option value="3" {{in_array('4',$level)?'selected':'';}}>Level 3</option>
                                            <option value="5" {{in_array('5',$level)?'selected':'';}}>Level 5</option>
                                            <option value="6" {{in_array('6',$level)?'selected':'';}}>Level 6</option>                                             --}}
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 cat_level2">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2"><b>Visible After Days</b> <small> (applicable for level 2 only)</small> </label>
                                        <input type="number" class="form-control" id="cat_level2" name="visiable_after_days"
                                            placeholder="visible after days" value="{{ $data_artical['visiable_after_days'] }}" min="3" max="999" >
                                    </div>
                                </div>
                                
                            </div>
                            <div class="row">
                                <div class="col-md-6 cat_level level6_com">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>company</b> <small> (applicable for level 6 only)</small> </label>
                                        @php
                                            $companys=json_decode($data_artical['company_id']);
                                        @endphp
                                        
                                        <select class="select2" multiple="multiple" id="level6_com" data-placeholder="Select a Company"
                                            style="width: 100%;" name="company_id[]">
                                            @foreach ($company as $companyKey => $companyValue)
                                            
                                                <option value="{{ $companyValue->company_id }}" {{in_array($companyValue->company_id,$companys)?'selected':'';}} >{{ $companyValue->company_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 cat_level level6_indu">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Industry</b> <small> (applicable for level 6 only)</small> </label>
                                        @php
                                            $industrys=json_decode($data_artical['industry_id']);
                                        @endphp
                                        <select class="select2" multiple="multiple" id="level6_indu" data-placeholder="Select a Industry"
                                            style="width: 100%;" name="industry_id[]">
                                            @foreach ($industry as $industryKey => $industryValue)
                                                <option value="{{ $industryValue->industry_id }}" {{in_array($industryValue->industry_id,$industrys)?'selected':'';}} >{{ $industryValue->industry_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                            </div> 
                            
                            
                            
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputName1" id="" class="mt-2"><b>Image</b></label>
                                        <input type="file" class="form-control" id="image" name="image[]"
                                            placeholder="Image" multiple accept="image/png, image/gif, image/jpeg" >
                                    </div>
                                </div>
                            </div>
                            <div class="row old_image">
                            @php
                                $img_data=json_decode($data_artical['image']);
                            @endphp
                            {{-- @if($data_artical['media_selection']=='Image') --}}

                                @if($img_data!=null)
                                @foreach ($img_data as $img)
                                    <img src="{{ asset('image/'.$img) }}" style="width:200px;height:200px;padding:10px;">
                                @endforeach
                                @endif
                            {{-- @endif --}}
                            </div>
                            <div class="row">
                                <div id="preview-container"></div>
                            </div>
                            
                            {{-- <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail3" class="mt-2"><b>Publisher</b></label>
                                        <input type="text" class="form-control" id="publisher" name="publisher"
                                            placeholder="Publisher" value="{{ $data_artical['publisher'] }}">
                                    </div>
                                </div>
                                
                            </div> --}}
                            
                            
                                                       
                            {{-- <label for="exampleInputName1" class="mt-2"><b>Article</b></label><br /> --}}
                            <div class="row">
                                
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Short Description</label>
                                        <textarea class="form-control" id="" name="artical_short_desc" rows="3" placeholder="Short Description" name="artical_short_desc">{{ $data_artical['artical_short_desc'] }}</textarea>
                                    </div>
                                </div>
                                {{-- <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Long Description</label>
                                        <textarea class="form-control" id="" name="artical_long_desc" rows="3" placeholder="Long Description" name="artical_long_desc">{{ $data_artical['artical_long_desc'] }}</textarea>
                                    </div>
                                </div> --}}

                                <div class="col-md-12">
                                    <label for="exampleInputName1" class="mt-2">Long Description</label>
                                    <div class="card card-outline card-info">
                                        <div class="card-body">
                                        <textarea id="summernote" name="artical_long_desc">
                                        {{ $data_artical['artical_long_desc'] }}
                                            {{-- Place <em>some</em> <u>text</u> <strong>here</strong> --}}
                                        </textarea>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            
                            
                            
                            <button type="button" class="btn mr-2 mt-5 btn-light" data-toggle="modal" data-target="#modal-default">
                                Preview
                            </button>
                            <button type="submit" class="btn mr-2 mt-5" id="submitTaxo"
                            style="background: #000000;color: #f0ac63 !important;">Update</button>
                            <button class="btn btn-light mt-5">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- <div class="col-12 grid-margin stretch-card">
        @if (session('status'))
            <div class="alert alert-success" role="alert">
                {{ session('status') }}
            </div>
        @endif

    </div> --}}
    <div class="modal fade" id="modal-default">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Default Modal</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              {!! $data_artical['artical_long_desc'] !!}
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
@endsection
@push('child-scripts')
    <script>


              $(function () {
    // Summernote
            $('#summernote').summernote()

            // CodeMirror
                CodeMirror.fromTextArea(document.getElementById("codeMirrorDemo"), {
                mode: "htmlmixed",
                theme: "monokai"
                });
            })

            
    </script>
    <script>
        // JavaScript code
        document.getElementById('image').addEventListener('change', function(event) {
            var previewContainer = document.getElementById('preview-container');
            previewContainer.innerHTML = ''; // Clear any existing previews
    
            var files = event.target.files;
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                var reader = new FileReader();
    
                reader.onload = function(e) {
                    var imageElement = document.createElement('img');
                    imageElement.src = e.target.result;
                    imageElement.classList.add('preview-image');
                    imageElement.classList.add('img_pre');
                    previewContainer.appendChild(imageElement);
                }
    
                reader.readAsDataURL(file);
            }
            $('.old_image').hide();
        });
    </script>
    <script>
        $(document).ready(function(){
           // alert('hello');
            $('.select2').select2();
            //Initialize Select2 Elements
            $('.select2bs4').select2({
                theme: 'bootstrap4',
            })

            $('.media_resource').hide();            
            $('.media_youtube').hide();
            $('.media_audio').hide();
            $('.cat_level2').hide();

            var media=$('#media').val();
            if(media=='Image')
            {
                $('.media_resource').show();
            }if(media=='Video')
            {
                $('.media_youtube').show();
            }if(media=='Audio')
            {
                $('.media_audio').show();
            }

            var selectedValues2 = []; // Initialize an empty array to store the values
            
            $('#sub_level option:selected').each(function() {
              selectedValues2.push($(this).val());
            });
            if ($.inArray('6', selectedValues2) !== -1) {
            
            }else{
                $('.level6_com').hide();            
                $('.level6_indu').hide();
                $('#cat_level').hide();
            }
            if ($.inArray('2', selectedValues2) !== -1) {
                    $('.cat_level2').show();
                } else {
                    $('.cat_level2').hide();
                   // $('#cat_level2').val("").trigger('change');

                }
            

            //alert('hello');
            
            


            

            var Media_select = jQuery('#media');
            var select = this.value;
            
            Media_select.change(function () {
                if ($(this).val() == 'Resource') {
                    $('.media_resource').show();
                    $('.media_youtube').hide();
                    $('.media_audio').hide();
                    $('#media_youtube').val(null);
                    $('#media_audio').val(null);
                } else if($(this).val() == 'Audio'){
                    $('.media_audio').show();
                    $('.media_resource').hide();
                    $('.media_youtube').hide();
                    $('#media_youtube').val(null);
                    $('#media_resource').val(null);
                } else if($(this).val() == 'Video'){
                    $('.media_youtube').show();
                    $('.media_resource').hide();
                    $('.media_audio').hide();
                    $('#media_resource').val(null);
                    $('#media_audio').val(null);
                }else if ($(this).val() == 'Article') {
                    $('.media_youtube').hide();
                    $('.media_resource').hide();
                    $('.media_audio').hide();
                    $('#media_youtube').val(null);
                    $('#media_resource').val(null);
                    $('#media_audio').val(null);
                }else{
                    $('.media_youtube').hide();
                    $('.media_resource').hide();
                    $('.media_audio').hide();
                    $('#media_youtube').val(null);
                    $('#media_resource').val(null);
                    $('#media_audio').val(null);
                }
                 
            });

            $('#sub_level').change(function() {
            var selectedValues = []; // Initialize an empty array to store the values
        
            $('#sub_level option:selected').each(function() {
              selectedValues.push($(this).val());
            });
            //alert(selectedValues);
            if ($.inArray('6', selectedValues) !== -1) {
              $('.level6_com').show();
              $('.level6_indu').show();
            } else {
              $('.level6_com').hide();
              $('#level6_com').val("").trigger('change');
              $('#level6_indu').val("").trigger('change');
              
              $('.level6_indu').hide();
            }
            if ($.inArray('2', selectedValues) !== -1) {
                    $('.cat_level2').show();
                } else {
                    $('.cat_level2').hide();
                    $('#cat_level2').val("").trigger('change');

                }
            
          });
        });
    </script>    



@endpush
