@extends('template.master')

@push('styles')
    <!-- Select2 -->
    {{-- <link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css')}}"> --}}
    <style>
        .img_pre {
            width: 200px;
            height: 200px;
            padding: 10px;
        }
        .note-editable{
            min-height: 300px !important;
        }
        .modal-content>.modal-body >p > img{
            object-fit: contain;
            width: 100% !important;
            height: 100% !important;
        }
        .modal-content>.modal-body > img{
            object-fit: contain;
            width: 100% !important;
            height: 100% !important;
        }
    </style>
@endpush


@section('content')
    <div class=" mt-4">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card card-secondary">
                    <div class="card-header" style="background: #000000;color: #f0ac63 !important;">
                        <h4 class="card-title" style="color: #f0ac63 !important;"><strong>Add/Edit Article</strong></h4>
                        <a href="{{ route('articles.list') }}" class="btn float-right"
                            style="background: #f0ac63;color: #000000 !important;">Back</a>
                    </div>
                    <div class="card-body">
                        <form class="form" id="taxo-form" action="{{ route('articles.add') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Article Title </label>
                                        <input type="text" class="form-control" id="article_name" name="article_name"
                                            placeholder="Article Name" required maxlength="255">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Search Text </label>
                                        <input type="text" class="form-control" id="search_text" name="search_text"
                                            placeholder="Search Text" required maxlength="255">
                                    </div>
                                </div>
                            </div>
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2"><b>Media Selection</b></label>
                                        {{-- <input type="text" class="form-control" id="name" name="name"
                                            placeholder="Name"> --}}
                                        <select class="select2" id="media" data-placeholder="Select a Media"
                                            style="width: 100%;" name="media_selection" required>
                                            <option value="NULL">Select Media</option>
                                            <option value="Article">Article</option>
                                            <option value="Resource">Resource</option>
                                            <option value="Audio">Audio</option>
                                            <option value="Video">Video</option>
                                            {{-- @foreach ($media as $mediaKey => $mediaValue)
                                                <option value="{{ $mediaKey }}">{{ $mediaValue->media_name }}</option>
                                            @endforeach --}}
                                        </select>

                                    </div>
                                </div>
                            
                            
                                <div class="col-md-6 media_resource">
                                    <div class="form-group">
                                        <label for="exampleInputName1" id="media_resource"
                                            class="mt-2"><b>Resource</b></label>
                                        <input type="file" class="form-control" id="media_resource" name="resource"
                                            placeholder="Resource" accept=".pdf,.doc">
                                    </div>
                                </div>
                                <div class="col-md-6 media_youtube">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2"><b>Video</b></label>
                                        <input type="text" class="form-control" id="media_youtube" name="youtube_url"
                                            placeholder="https://">
                                    </div>
                                </div>
                                <div class="col-md-6 media_audio">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2"><b>Audio</b></label>
                                        {{-- <input type="file" class="form-control" id="media_audio" name="audio"
                                            placeholder="audio" accept="audio/mp3,audio/*;capture=microphone" /> --}}
                                            <input type="text" class="form-control" id="media_audio" name="audio"
                                            placeholder="https://">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        @php
                                            $da = date('Y-m-d');
                                        @endphp
                                        <label for="exampleInputEmail3" class="mt-2"><b>Article Date</b></label>
                                        <input type="date" class="form-control" id="publish_date" name="publish_date"
                                            placeholder="Publish Date" value="{{ $da }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail3" class="mt-2"><b>Publisher</b></label>
                                        <select class="select2" id="publisher"
                                            data-placeholder="Select a Publisher" style="width: 100%;" name="publisher" required>
                                            <option value="NULL">Select Publisher</option>
                                            @foreach ($publisher as $publisherKey => $publisherValue)
                                                <option value="{{ $publisherValue->publisher_name }}">{{ $publisherValue->publisher_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <!--<input list="select"  class="form-control"  id="publisher" name="publisher"-->
                                        <!--    placeholder="Select a publisher" required maxlength="255">-->
                                        <!--<datalist id="select">-->
                                        <!--    @foreach ($publisher as $publisherKey => $publisherValue)-->
                                        <!--        <option value="{{ $publisherValue->publisher_name }}"></option>-->
                                        <!--    @endforeach-->
                                        <!--</datalist>-->
                                       

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 cat_level">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Category</b></label>
                                        <select class="select2" id="" multiple="multiple"
                                            data-placeholder="Select a Category" style="width: 100%;" name="category_id[]" required>
                                            @foreach ($category as $catKey => $catValue)
                                                <option value="{{ $catValue->category_id }}">{{ $catValue->category_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Interest</b></label>
                                        <select class="select2" multiple="multiple" data-placeholder="Select a Interest"
                                            style="width: 100%;" name="interest_id[]" required>
                                            @foreach ($interest as $interestKey => $interestValue)
                                                <option value="{{ $interestKey }}">{{ $interestValue->interest_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Subscription level</b></label>
                                        {{-- {{ dd($subscription) }} --}}
                                        <select class="select2 sub_level" id="sub_level" multiple="multiple"
                                            data-placeholder="Select a Subscription" style="width: 100%;"
                                            name="subscription_level[]" required>
                                            @foreach ($subscription as $subscriptionKey => $subscriptionValue)
                                                <option value="{{ $subscriptionValue->subscription_id }}" @php if(  $subscriptionValue->subscription_id == '1'){ echo 'selected';} @endphp>
                                                    {{ $subscriptionValue->subscription_level }} -
                                                    {{ $subscriptionValue->subscription_name }}</option>
                                            @endforeach
                                            {{-- <option value="1">Level 1</option>
                                            <option value="2">Level 2</option>
                                            <option value="3">Level 3</option>
                                            <option value="4">Level 4</option>
                                            <option value="5">Level 5</option>
                                            <option value="6">Level 6</option>                                             --}}
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 cat_level2">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Visible After Days</b><small> (applicable for level 2 only)</small></label>
                                        <input type="number" class="form-control" id="cat_level2"
                                            name="visiable_after_days" placeholder="visible after days" min="3" max="999">
                                    </div>
                                </div>
                                
                            </div>
                            <div class="row">
                                
                                <div class="col-md-6 cat_level level6_com">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Company</b> <small> (applicable for level 6 only)</small></label>
                                        <select class="select2" id="level6_com" multiple="multiple"
                                            data-placeholder="Select a Company" style="width: 100%;" name="company_id[]">
                                            @foreach ($company as $compKey => $compValue)
                                                <option value="{{ $compValue->company_id }}">{{ $compValue->company_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 cat_level level6_indu">
                                    <div class="form-group">
                                        <label for="exampleInputName1"><b>Industry</b> <small> (applicable for level 6 only)</small></label>
                                        <select class="select2 " id="level6_indu" multiple="multiple"
                                            data-placeholder="Select a Industry" style="width: 100%;" name="industry_id[]">
                                            @foreach ($industry as $industryKey => $industryValue)
                                                <option value="{{ $industryValue->industry_id }}">
                                                    {{ $industryValue->industry_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            
                            <div class="row">
                                <div class="col-md-6 media_image">
                                    <div class="form-group">
                                        <label for="exampleInputName1" id="media_image"
                                            class="mt-2"><b>Image</b></label>
                                        <input type="file" class="form-control" id="image" name="image[]"
                                            placeholder="Image" accept="image/png, image/gif, image/jpeg" multiple>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div id="preview-container"></div>
                            </div>



                            {{-- <div class="row ">
                                <div class="col-md-6 media_audio">
                                    <div class="form-group">
                                        <label for="exampleInputName1"  class="mt-2"><b>Audio</b></label>
                                        <input type="file" class="form-control" id="media_audio" name="audio"
                                            placeholder="audio">
                                    </div>
                                </div>
                            </div> --}}
                            
                            
                           
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Short Description</label>
                                        <textarea class="form-control" id="" name="artical_short_desc" rows="3"
                                            placeholder="Short Description" name="artical_short_desc" required></textarea>
                                    </div>
                                </div>
                                {{-- <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="exampleInputName1" class="mt-2">Long Description</label>
                                        <textarea class="form-control" id="" name="artical_long_desc" rows="3" placeholder="Long Description" name="artical_long_desc"></textarea>
                                    </div>
                                </div> --}}
                                <div class="col-md-12">
                                    <label for="exampleInputName1" class="mt-2">Long Description</label>
                                    <div class="card card-outline card-info">
                                        <div class="card-body">
                                            <textarea id="summernote" name="artical_long_desc" required>
                                            Place <em>some</em> <u>text</u> <strong>here</strong>
                                        </textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            {{-- <div class="row">
                                
                            </div> --}}
                            <button type="button" class="btn mr-2 mt-5 btn-light" data-toggle="modal" data-target="#exampleModal" data-whatever="123">Preview</button>
                            <button type="submit" class="btn mr-2 mt-5" id="submitTaxo"
                                style="background: #000000;color: #f0ac63 !important;">Submit</button>
                            <button class="btn btn-light mt-5">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- <div class="col-12 grid-margin stretch-card">
        @if (session('status'))
            <div class="alert alert-success" role="alert">
                {{ session('status') }}
            </div>
        @endif

    </div> --}}
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Preview</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
    </div>
@endsection
@push('child-scripts')
    {{-- <script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script> --}}
    {{-- <script src="{{ asset('plugins/bs-stepper/js/bs-stepper.min.js') }}"></script> --}}

    <script>
        // JavaScript code
        $('#exampleModal').on('show.bs.modal', function (event) {
           
            $d=$("#summernote").val();
            var button = $(event.relatedTarget)
            var recipient = button.data('whatever')
            var modal = $(this)
            
            modal.find('.modal-body').html($d)
        })
        document.getElementById('image').addEventListener('change', function(event) {
            var previewContainer = document.getElementById('preview-container');
            previewContainer.innerHTML = ''; // Clear any existing previews

            var files = event.target.files;
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                var reader = new FileReader();

                reader.onload = function(e) {
                    var imageElement = document.createElement('img');
                    imageElement.src = e.target.result;
                    imageElement.classList.add('preview-image');
                    imageElement.classList.add('img_pre');
                    previewContainer.appendChild(imageElement);
                }

                reader.readAsDataURL(file);
            }
        });
    </script>
    <script>
        $(document).ready(function() {
            //$('#publish_date').val(new Date);
            // alert('hello');
            $('.select2').select2();
            //Initialize Select2 Elements
            $('.select2bs4').select2({
                theme: 'bootstrap4',
            })


            $('.level6_com').hide();
            $('.level6_indu').hide();
            $('#cat_level').hide();
            $('.cat_level2').hide();


            $('.media_resource').hide();
            $('.media_youtube').hide();
            $('.media_audio').hide();

            var Media_select = jQuery('#media');
            var select = this.value;

            Media_select.change(function() {
                if ($(this).val() == 'Resource') {
                    $('.media_resource').show();
                    $('.media_youtube').hide();
                    $('.media_audio').hide();
                    $('#media_youtube').val(null);
                    $('#media_audio').val(null);
                } else if ($(this).val() == 'Audio') {
                    $('.media_audio').show();
                    $('.media_resource').hide();
                    $('.media_youtube').hide();
                    $('#media_youtube').val(null);
                    $('#media_resource').val(null);
                } else if ($(this).val() == 'Video') {
                    $('.media_youtube').show();
                    $('.media_resource').hide();
                    $('.media_audio').hide();
                    $('#media_resource').val(null);
                    $('#media_audio').val(null);
                }else if ($(this).val() == 'Article') {
                    $('.media_youtube').hide();
                    $('.media_resource').hide();
                    $('.media_audio').hide();
                    $('#media_youtube').val(null);
                    $('#media_resource').val(null);
                    $('#media_audio').val(null);
                }else{
                    $('.media_youtube').hide();
                    $('.media_resource').hide();
                    $('.media_audio').hide();
                    $('#media_youtube').val(null);
                    $('#media_resource').val(null);
                    $('#media_audio').val(null);
                }

            });

            $('#sub_level').change(function() {
                var selectedValues = []; // Initialize an empty array to store the values

                $('#sub_level option:selected').each(function() {
                    selectedValues.push($(this).val());
                });
                //alert(selectedValues);
                if ($.inArray('6', selectedValues) !== -1) {
                    $('.level6_com').show();
                    $('.level6_indu').show();
                } else {
                    $('.level6_com').hide();
                    $('#level6_com').val("").trigger('change');
                    $('#level6_indu').val("").trigger('change');

                    $('.level6_indu').hide();
                }
                if ($.inArray('2', selectedValues) !== -1) {
                    $('.cat_level2').show();
                } else {
                    $('.cat_level2').hide();
                    $('#cat_level2').val("").trigger('change');

                }
                //$('#selectedValues').text(selectedValues.join(', '));
            });
        });
    </script>

    <script>
        $(function() {
            // Summernote
            $('#summernote').summernote()

            // CodeMirror
            CodeMirror.fromTextArea(document.getElementById("codeMirrorDemo"), {
                mode: "htmlmixed",
                theme: "monokai"
            });
        })
        // $(function() {
        //     //Initialize Select2 Elements
        //     $('.select2').select2()

        //     //Initialize Select2 Elements
        //     $('.select2bs4').select2({
        //         theme: 'bootstrap4'
        //     })

        //     //Datemask dd/mm/yyyy
        //     // $('#datemask').inputmask('dd/mm/yyyy', {
        //     //     'placeholder': 'dd/mm/yyyy'
        //     // })
        //     // //Datemask2 mm/dd/yyyy
        //     // $('#datemask2').inputmask('mm/dd/yyyy', {
        //     //     'placeholder': 'mm/dd/yyyy'
        //     // })
        //     // //Money Euro
        //     // $('[data-mask]').inputmask()

        //     // //Date picker
        //     // $('#reservationdate').datetimepicker({
        //     //     format: 'L'
        //     // });

        //     //Date and time picker
        //     // $('#reservationdatetime').datetimepicker({
        //     //     icons: {
        //     //         time: 'far fa-clock'
        //     //     }
        //     // });

        //     // //Date range picker
        //     // $('#reservation').daterangepicker()
        //     // //Date range picker with time picker
        //     // $('#reservationtime').daterangepicker({
        //     //     timePicker: true,
        //     //     timePickerIncrement: 30,
        //     //     locale: {
        //     //         format: 'MM/DD/YYYY hh:mm A'
        //     //     }
        //     // })
        //     //Date range as a button
        //     // $('#daterange-btn').daterangepicker({
        //     //         ranges: {
        //     //             'Today': [moment(), moment()],
        //     //             'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        //     //             'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        //     //             'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        //     //             'This Month': [moment().startOf('month'), moment().endOf('month')],
        //     //             'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
        //     //                 'month').endOf('month')]
        //     //         },
        //     //         startDate: moment().subtract(29, 'days'),
        //     //         endDate: moment()
        //     //     },
        //     //     function(start, end) {
        //     //         $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format(
        //     //             'MMMM D, YYYY'))
        //     //     }
        //     // )

        //     //Timepicker
        //     // $('#timepicker').datetimepicker({
        //     //     format: 'LT'
        //     // })

        //     // //Bootstrap Duallistbox
        //     // $('.duallistbox').bootstrapDualListbox()

        //     // //Colorpicker
        //     // $('.my-colorpicker1').colorpicker()
        //     // //color picker with addon
        //     // $('.my-colorpicker2').colorpicker()

        //     // $('.my-colorpicker2').on('colorpickerChange', function(event) {
        //     //     $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
        //     // })

        //     // $("input[data-bootstrap-switch]").each(function() {
        //     //     $(this).bootstrapSwitch('state', $(this).prop('checked'));
        //     // })

        // });
        // BS-Stepper Init
        // document.addEventListener('DOMContentLoaded', function() {
        //     window.stepper = new Stepper(document.querySelector('.bs-stepper'))
        // })

        // // DropzoneJS Demo Code Start
        // Dropzone.autoDiscover = false

        // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
        // var previewNode = document.querySelector("#template")
        // previewNode.id = ""
        // var previewTemplate = previewNode.parentNode.innerHTML
        // previewNode.parentNode.removeChild(previewNode)

        // var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
        //     url: "/target-url", // Set the url
        //     thumbnailWidth: 80,
        //     thumbnailHeight: 80,
        //     parallelUploads: 20,
        //     previewTemplate: previewTemplate,
        //     autoQueue: false, // Make sure the files aren't queued until manually added
        //     previewsContainer: "#previews", // Define the container to display the previews
        //     clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
        // })

        // myDropzone.on("addedfile", function(file) {
        //     // Hookup the start button
        //     file.previewElement.querySelector(".start").onclick = function() {
        //         myDropzone.enqueueFile(file)
        //     }
        // })

        // // Update the total progress bar
        // myDropzone.on("totaluploadprogress", function(progress) {
        //     document.querySelector("#total-progress .progress-bar").style.width = progress + "%"
        // })

        // myDropzone.on("sending", function(file) {
        //     // Show the total progress bar when upload starts
        //     document.querySelector("#total-progress").style.opacity = "1"
        //     // And disable the start button
        //     file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
        // })

        // // Hide the total progress bar when nothing's uploading anymore
        // myDropzone.on("queuecomplete", function(progress) {
        //     document.querySelector("#total-progress").style.opacity = "0"
        // })

        // // Setup the buttons for all transfers
        // // The "add files" button doesn't need to be setup because the config
        // // `clickable` has already been specified.
        // document.querySelector("#actions .start").onclick = function() {
        //     myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
        // }
        // document.querySelector("#actions .cancel").onclick = function() {
        //     myDropzone.removeAllFiles(true)
        // }
        // DropzoneJS Demo Code End
    </script>
@endpush
